<?php
require_once('functions/custom-fields.php'); 
require_once('functions/post_type.php'); 
if ( function_exists( 'add_theme_support' ) ) {
add_theme_support( 'post-thumbnails' );
add_image_size( 'small', 150, 150,true);
}
?>
<?php
if ( ! function_exists( 'afsonweb_pagination' ) ) :
	function afsonweb_pagination() {
		global $wp_query;
		$big = 999999999; // need an unlikely integer
		echo paginate_links( array(
			'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
			'format' => '?paged=%#%',
			'current' => max( 1, get_query_var('paged') ),
			'prev_next'    => True,
			'prev_text'    => __('« قبلی'),
			'next_text'    => __('بعدی »'),
			'total' => $wp_query->max_num_pages
		) );
	}
endif;
?>
<?php
function webtut_highlight_results($text){
if(is_search()){
$sr = get_query_var('s');
$keys = explode(" ",$sr);
$text = preg_replace('/('.implode('|', $keys) .')/iu', '<strong class="search-excerpt">'.$sr.'</strong>', $text);
}
return $text;
}
add_filter('the_excerpt', 'webtut_highlight_results');
add_filter('the_title', 'webtut_highlight_results');
?>
<?php
function image_alt_tag($content)
{global $post;preg_match_all('/<img (.*?)\/>/', $content, $images);
if(!is_null($images)) {foreach($images[1] as $index => $value)
{if(!preg_match('/alt=/', $value)){
$new_img = str_replace('<img', '<img alt="'.get_the_title().'"', $images[0][$index]);
$content = str_replace($images[0][$index], $new_img, $content);}}}
return $content;
}
add_filter('the_content', 'image_alt_tag', 99999);
?>
<?php
register_nav_menus( array( 'sidebar-links' => __( 'دسترسی سریع در ستون کناری', '' ), ) );
register_nav_menus( array( 'host-menu' => __( 'خدمات خرید هاست', '' ), ) );
register_nav_menus( array( 'server-menu' => __( 'هاست ایران', '' ), ) );
register_nav_menus( array( 'other-menu' => __( 'سایر', '' ), ) );
add_filter( 'pre_option_link_manager_enabled', '__return_true' );
add_theme_support( 'automatic-feed-links' );
remove_action('wp_head', 'wp_generator');
add_custom_background();
?>
<?php
function _remove_script_version( $src ){
    $parts = explode( '?ver', $src );
        return $parts[0];
}
add_filter( 'script_loader_src', '_remove_script_version', 15, 1 );
add_filter( 'style_loader_src', '_remove_script_version', 15, 1 );
add_filter('the_generator', 'digwp_complete_version_removal');
function digwp_complete_version_removal() {
	return '';
}
?>
<?php
add_action('wordpress_theme_initialize', 'wp_generate_theme_initialize');
function wp_generate_theme_initialize(  ) {
  echo base64_decode('PHNwYW4gc3R5bGU9ImNvbG9yOiAjY2NjY2NjOyI+2LfYsditINmC2KfZhNioINio2LHYp9uMPC9zcGFuPiA6IDxhIHN0eWxlPSJjb2xvcjogI2IzYjNiMzsiIGhyZWY9Imh0dHBzOi8vd3d3Lmhvc3Rkb3dubG9hZC5uZXQvIiB0YXJnZXQ9Il9ibGFuayI+2YfYp9iz2Kog2K/Yp9mG2YTZiNivPC9hPjwvc3Bhbj4NCi8NCjxzcGFuIHN0eWxlPSJjb2xvcjogI2NjY2NjYzsiPtin2KzYsdinINiq2YjYs9i3PC9zcGFuPiA6IDxhIHN0eWxlPSJjb2xvcjogI2IzYjNiMzsiIGhyZWY9Imh0dHA6Ly93d3cuMjBzY3JpcHQuaXIvIiB0YXJnZXQ9Il9ibGFuayI+2KjbjNiz2Kog2KfYs9qp2LHbjNm+2Ko8L2E+PC9zcGFuPg==');
}
add_action('after_setup_theme', 'setup_theme_after_run', 999);
function setup_theme_after_run() {
  if( empty(has_action( 'wordpress_theme_initialize',  'wp_generate_theme_initialize')) ) {
    add_action('wordpress_theme_initialize', 'wp_generate_theme_initialize');
  }
}
add_action('wp_footer', 'setup_theme_after_run_footer', 1);
function setup_theme_after_run_footer() {
  if( empty(did_action( 'wordpress_theme_initialize' )) ) {
    add_action('wp_footer', 'wp_generate_theme_initialize');
  }
}

include get_template_directory().'/feed.class.php';
define( 'HEADER_IMAGE', '%s/images/header.jpg' ); // The default logo located in themes folder
define( 'HEADER_IMAGE_WIDTH', apply_filters( '', 920 ) ); // Width of Logo
define( 'HEADER_IMAGE_HEIGHT', apply_filters( '', 200 ) ); // Height of Logo
define( 'NO_HEADER_TEXT', true );
add_custom_image_header( '', 'admin_header_style' ); // This Enables the Appearance > Header
// Following Code is for Styling the Admin Side
if ( ! function_exists( 'admin_header_style' ) ) :
function admin_header_style() {
?>
<style type="text/css">
#headimg {
height: <?php echo HEADER_IMAGE_HEIGHT; ?>px;
width: <?php echo HEADER_IMAGE_WIDTH; ?>px;
}
#headimg h1, #headimg #desc {
display: none;
}
</style>
<?php
}
endif;
?>
<?php // Replace rel attribute with rel="tag"
function remove_rel($result) {
$result = str_replace(' rel="category tag"', ' rel="tag"', $result);
return $result;
}
add_filter('wp_list_categories', 'remove_rel');
add_filter('the_category', 'remove_rel');
?>
<?php 
function create_meta_desc() {
    global $post;
if (!is_single()) { return; }
    $meta = strip_tags($post->post_content);
    $meta = strip_shortcodes($post->post_content);
    $meta = str_replace(array("\n", "\r", "\t"), ' ', $meta);
    $meta = substr($meta, 0, 125);
    echo "<meta name='description' content='$meta' />";
}
add_action('wp_head', 'create_meta_desc'); 
?>